package edu.unl.consystlab.sudokuSolver;
import edu.unl.consystlab.sudokuSolver.constructorInterface;
import javax.swing.JButton;
import javax.swing.JLabel;
import java.util.List;


public class solverThreadForSol extends Thread{

	private constraintProblem problemToSolve;
	private forwardCheckingSearch mySearch;
	private boolean finishedSearching;
	sudokuInterface parentInterface;
	
	
	public solverThreadForSol(constraintProblem newProblem, sudokuInterface inputInterface)
	{
		parentInterface = inputInterface;
		this.setDaemon(true);
		this.setPriority(2);
		problemToSolve = newProblem;
		finishedSearching = false;
	}
	
	public void run()
	{
            try {
		mySearch = new forwardCheckingSearch(problemToSolve);
		mySearch.solve();
		finishedSearching = true;
		parentInterface.setSoluList(this.getSolutionsList());
		parentInterface.displayNextSols(this.getSolutionsList());
		return;
            } catch (InterruptedException ex) {
                // Bad things happen if we get here...
            }
	}
	
	public int getSolutions()
	{
		if(finishedSearching)
		{
			return mySearch.getSolutionNum();
		}
		else
		{
			return -1;
		}
	}
	
	public List getSolutionsList()
	{
		if(finishedSearching)
		{
			
			return mySearch.getSolutions();
		}
		else
		{
			return null;
		}
	}
}
